# Player Config ID: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A (as Player A)
# Meta-Round: 8
# Experiment: PMxPM, Run: 4
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_PayoffMaximizer_A_MR8_strategy.txt
# LLM Suggested Fallback: C

def serendipitous_phoenix(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    if not my_history:
        return "C"  # Initial cooperation to build trust
    
    # Detect unconditional strategies
    always_c = "return 'c'" in opponent_program_code.lower() or "always cooperate" in opponent_program_code.lower()
    always_d = "return 'd'" in opponent_program_code.lower() or "always defect" in opponent_program_code.lower()
    
    if always_c:
        return "D"  # Exploit always-C opponents
    if always_d:
        return "D"  # Minimize losses against always-D opponents
    
    # Check for recent defections
    if len(opp_history) >= 2 and opp_history[-1] == "D" and opp_history[-2] == "D":
        return "D"  # Retaliate for two consecutive defections
    
    # Late-game adjustment
    if len(my_history) >= 8:  # Final 2 rounds (9-10)
        if "D" not in opp_history[-3:]:  # No recent retaliation
            return "D"  # Capitalize on endgame opportunism
    
    # Default to cooperation if no conditions met
    return "C"